#   Copyright 1986 Intel Corporation
#
#   Delete a list of features from a remote node.
#
#   param 1 -- node name from which to delete a list of features
#   param 2 -- feature to delete
#
# 05/13/86  rhc add PATH for Ar usage

PATH=/bin:/usr/bin	export PATH
d_node=$1
export d_node
shift
#
echo -n "Confirm that you wish to delete the $1 feature? (y or n): "
read answer
echo
case $answer in
   y|yes)
	  ;;
   *)
	  echo "
The $1 feature is not deleted."
	  exit 0
	  ;;
esac
	 
#
idis=`$iDISBIN/Unonode $iDIS`
idisbin=`$iDISBIN/Unonode $iDISBIN`
#   First make sure that feature installation/deletion is not in progress.
#
$iDISBIN/Flock -x //$d_node$idis/fb_lock -e sleep 0
if [ $? != 0 ] ; then
   echo
   echo "   Feature installation/deletion is currently under progress on"
   echo "     node $d_node. Please try later."
   exit 0
fi
#
echo -n "Starting the feature deletion on node $d_node ..."

ORGIFS=$IFS
IFS=/
s_node=`net name`
IFS=$ORGIFS

remotescript=//$d_node/tmp/$s_node$$

ttydev=`net name``tty`
cat > $remotescript <<-HERE
:  # force in to bourne shell.
PATH=/bin:/etc:/usr/bin:.
export PATH

# ignore quit signal (2) and cleanup otherwise.
trap "" 2
trap "rm $remotescript;exit" 0 1 3 15

(
fbtty=$ttydev
iDISBIN=$idisbin
iDIS=$idis
export iDISBIN iDIS fbtty
#  invoke feature delete
\$iDISBIN/Afxdel $ttydev $*
#
#   See whether there are any errors
if [ -f \$iDIS/report ] ; then
  count=\`grep -c "^[^> ]" \$iDIS/report\`
  if [ \$count -gt 0 ] ; then
    errors=
  else
    errors="NO "
  fi
fi
#   append the latest feature deletion activity information contained
#    in the report file to the zaplog file for future reference.
#
echo "iDIS SOFTWARE FEATURE DELETION on `date`" >> \$iDIS/zaplog
cat \$iDIS/report >> \$iDIS/zaplog
echo " " >> \$iDIS/zaplog
#
#  Next insert the message as how to look for errors in report file.
#
cd \$iDIS
echo "NOTE: Please look for lines that start in column 1" > report.tmp1
echo " (but not with a '>' character) to identify errors, if any." >> report.tmp1
cat report >> report.tmp1
rm report
mv report.tmp1 report
# 
chown iDIS report debug
chmod 444 report debug
#
#  Now that we are done with feature deletion, send mail to the
#   user who initiated the feature deletion process.
#
mail -s "Deletion of $* feature on node $d_node" `logname` > /dev/null <<!
The deletion of $* feature on node $d_node is complete.
There were \${errors}errors during the feature deletion. 
For more details, please check the report file by selecting 
'view' selection on 'Afinst' menu.
!
#
if [ "\$errors" = "NO " ] ; then
  echo "
  The feature deletion is successful.
  " | tee -a report | tee -a zaplog
else
  echo "
  Errors were encountered during the feature deletion.
  For more details, please check the report file by selecting  
  'view' selection on 'Afinst' menu.
  " | tee -a report | tee -a zaplog
fi
echo
#
echo "/* ---------------------------------------------------------------- */"\
         >> zaplog
echo " " >> zaplog
#
exit 0
) > $ttydev
#
HERE
#
chmod 700 $remotescript
#
#  Determine whether we have to tell the user to hang around.
for feat in $*
  do
    count=`grep -c "^$feat" $idis/fb_interactive`
    if [ $count -gt 0 ] ; then
      echo
      echo " 
 NOTE:  During the deletion of $feat feature on node $d_node,
        you will be asked to respond to certain questions. You MUST
        respond to those questions within ONE MINUTE. Otherwise, it 
	will result in improper deletion."
    fi

  done
#
#  Now all the preparatory work is done. So it is time to do the
#   real task., ie. rexec on the remote node
#
echo
rexec //$d_node$idisbin/Flock -x //$d_node$idis/fb_lock -e $remotescript -- /dev/null 
#
#  Feature delete is executing on the remote node. It requires user
#   to respond to few questions. So, we should tie up the local
#   terminal until the feature delete is done executing at remote
#   node.
#
while [ -f $remotescript ]
  do
    sleep 3
  done
#
