: SCRIPT Fedit.ss
# Copyright 1986 Intel Corporation
# File management - edit file(s)
#
# Parms are:
#	$1 : cabinet_type
#	$n : files to be edited
#
dc=$1; shift
if [ ! -x $FEDITOR ] ; then
	echo ERROR ... Your preferred editor \($FEDITOR\) cannot be found.
	echo "          Contact your system administrator."
fi
for file do
	if [ $file = NEW ] ; then
		while true ; do
			echo
			echo -n "Enter name of NEW file to edit (or RETURN to bypass) ==> "
			read file
			if [ "$file" = "" ] ; then
				break
			fi
			if $iDISBIN/Fbadname.ss $file $dc ; then
				continue
			fi
			if [ -r $file ] ; then
				echo -n "$file already exists"
				if [ -w $file -a -f $file ] ; then
					echo -n " ... edit it? (y or n): " 
					read ans
					if [ "$ans" != "y" ] ; then
						continue
					fi
				else
					echo ", but is not editable"
					continue
				fi
			else
				>$file
			fi
			$iDISBIN/Flock -r $file -e $FEDITOR $file
			if [ $? -eq 201 -o $? -eq 202 ] ; then
				echo "$file not available at present ... try later"
			fi
		done
	else
		$iDISBIN/Flock -r $file -e $FEDITOR $file
		if [ $? -eq 201 -o $? -eq 202 ] ; then
			echo "$file not available at present ... try later"
		fi
	fi
done
