/*  General purpose Button class.  Most buttons are defined along
 with a dialog box, but the Button class enables you to create and
 use buttons in Actor windows even when they weren't defined as part
 of a dialog. */ !!

inherit(Control, #Button, #( state /* True or false flag */), nil, nil) !!

now(ButtonClass) !!

#define BS_DEFPUSHBUTTON 1
#define BS_CHECKBOX      2
#define BS_AUTOCHECKBOX  3
#define BS_RADIOBUTTON   4
/* #define BS_3STATE        5
	#define BS_AUTO3STATE    6
	#define BS_GROUPBOX      7
	#define BS_USERBUTTON    8	*/ !!

/* Create and return a new button object in Actor and Windows.
  Parent passes the control id, self, the name of the
  new button.  The style argument is a constant which defines
  what type of button will be created (see the Actor manual,
  in the Guide to the Actor Classes).  */
Def  new(self, id, par, name, style | theBut)
{	theBut := new(self:Behavior);	/* create object */
	theBut.contID := id;
	theBut.parent := par;
	create(theBut, name, "BUTTON", style + WS_CHILD);
	^theBut;
} !!

/* Create and return a new push button. */
Def  newPush(self, id, par, name)
{	^new(self, id, par, name, BS_PUSHBUTTON)
} !!	

/* Create and return a new default push button. */
Def  newDefPush(self, id, par, name)
{	^new(self, id, par, name, BS_DEFPUSHBUTTON)
} !!	

/* Create and return a new radio button. */
Def  newRadio(self, id, par, name)
{	^new(self, id, par, name, BS_RADIOBUTTON)
} !!
	
/* Create and return a new check box. */
Def  newCheck(self, id, par, name)
{	^new(self, id, par, name, BS_CHECKBOX)
} !!

now(Button) !!

/* Return the button state.  True if the user is
  pushing the button.  */
Def   getState(self)
{	^state := (sendMessage(self, BM_GETSTATE, 0, 0) ~= 0);
} !!

/* Set the button state. */
Def   setState(self, flag | val)
{	if state := flag
	then val := 1
	else val := 0
	endif;
	^sendMessage(self, BM_SETSTATE, val, 0);
} !!

/* Flip the button state, return new state. */
Def   flipState(self)
{	setState(self, not(state)); ^state
} !!

/* Return the check box or radio button state. */
Def   getCheck(self)
{	^state := (sendMessage(self, BM_GETCHECK, 0, 0) ~= 0);
} !!

/* Set the check box or radio button state. */
Def   setCheck(self, flag | val)
{	if state := flag
	then val := 1
	else val := 0
	endif;
	^sendMessage(self, BM_SETCHECK, val, 0);
} !!

/* Flip the check box or radio button state, return new state. */
Def   flipCheck(self)
{	setCheck(self, not(state));	
  ^state;
} !!


