/* An CharInterval represents a series of characters.
 Example: do(over('a', 'z'), {using(ch)  print(ch) })
 Prints:  abcdefghijklmnopqrstuvwxy
 Example: do(overBy('z', 'a', -1), {using(i) print(ch) })
 Prints:  zyxwvutsrqponmlkjihgfedcb

 CharIntervals are just regular intervals of ASCII values.  */  !!

inherit(Interval, #CharInterval, nil, 2, nil) !!

now(class(CharInterval)) !!

now(CharInterval) !!

/* Return the number of elements in the CharInterval.  */
Def size(self)
{  ^max((asInt(stop)-asInt(start) + step - 1)/step,0);
}!!

/* Return the character at the specified
  index of the receiver.  */
 Def at(self, idx)
{
  if  idx >= 0 and idx < size(self)
  then ^asChar(idx * step + asInt(start));
  else error(self, stackTop(0),
    #rangeError);
  endif;
}!!


/* Evaluate the one-argument block over the
  elements of the receiver.  */
Def do(self, aBlock)
{   do(new(Interval,asInt(start),asInt(stop),step),
       {using(code) eval(aBlock, asChar(code))
       });
}!!

/* Return true if val is in the set
  represented by the CharInterval.  */
 Def in(self, val)
{
  if step > 0
  then ^(asInt(val) - asInt(start)) mod
    step == 0 and val >= start and val <
    stop;
  else ^(asInt(val) - asInt(start)) mod
    step == 0 and val <= start and val >
    stop;
  endif;
} !!
+