/* Class ListBox for the Browser.  This class creates and manages
  the list of classes which appear in the upper left corner of
  every Browser window.  */!!

inherit(ListBox, #ClassList, nil, nil, nil) !!

now(ClassListClass) !!

now(ClassList) !!

/* Use either Object's descendants, or the specified collection of classes
 coll, to load the listbox.  If aClass is not nil, show that class as the
 currently selected item in list.  */
Def   fill(self, coll, aClass | str, aDict, idx, pos)
{ clearList(self);
  sendMessage(self, WM_SETREDRAW, 0, 0);
  if coll
  then do(coll,
      { using(aCl)     idx := insertString(self, aCl.name, -1);
      });
    if aClass
    then selectString(self, aClass.name)
    endif
  else aDict := buildClassLists(Actor);
    descendantsDo(Object, aDict,
      { using(aCl, level)
      if level = 0
      then str := aCl.name
      else str := stringOf(' ',level) + aCl.name
      endif;
      idx := insertString(self, str, -1);
      if aClass == aCl
      then pos := idx
      endif;
      }, 0);
    if pos
    then setCurSel(self, asInt(pos))
    endif;
  endif;
  sendMessage(self, WM_SETREDRAW, 1, 0);
  Call InvalidateRect(hCntl, 0, 0);
} !!

/* Return the selected class represented as a symbol. */
Def   getSelClass(self)
{ 
  ^Actor[asSymbol(leftJustify(getSelString(self)))];
} !!

