/* A Real is designed for very large or very small numbers,
 or any number with a fractional part. A Real is sometimes
 represented (depending on how big or small it is) in
 scientific notation, such as 1.334e+083, which means
 1.334 times 10 to the 83rd power.

 Actor represents its reals in 8 bytes, equivalent to Microsoft
 C's double data type.  Technically, an Actor Real is in the
 IEEE double-precision floating point format.

 Numbers from 1.7e-308 to 1.7e+308 (or their negatives) can be
 represented as Actor Real objects.  */!!

/* inherit(Number, #Real, nil, nil, nil) */!!

now(class(Real))!!

now(Real) !!

/* Generality for Real objects.  Return 
  2.  */
Def generality(self)
{ ^2
}!!


/* Return the message used to coerce 
  other numerics to this class.  */
 Def converterFor(self)
{ ^#asReal;
}!!


/* Return self.  Included only so that 
  you can send asReal messages to any 
  number.  */
Def asReal(self)
{
}!!


/* Return receiver as an Int.  If the 
  receiver is too large to be converted 
  into an Int, an error is generated.  */
 Def asInt(self)
{ ^asInt(asLong(self));
}!!

/* Return the negative of the receiver. 
  For instance, negate(3.0) returns -3.0. 
  negate(-49.8) returns 49.8.  Zero, of 
  course, has no negative, so negate(0.0) 
  is 0.0.  */
 Def negate(self)
{ ^0.0 - self;
}!!


/* Return the receiver, which is assumed 
  to be in degrees, converted to radians.  
  */
 Def degToRad(self)
{       ^self * pi / 180.
}!!

/* Return the receiver, which is assumed 
  to be in radians, converted to degrees.  
  */
 Def radToDeg(self)
{       ^self * 180. / pi
}!!


/* Multiplication operator.  Example: 
  3.0*4.0. */
 Prim *(self, y):Real!!


/* Addition operator.  Example: 3.0+4.0. */
 Prim +(self, y):Real!!


/* Subtraction operator.  Example: 
  10.0-2.0. */
 Prim -(self, y):Real !!


/* Division operator.  For example, 
  3.0/4.0 is 0.75. Note that the receiver 
  Real is actually the numerator, i.e. in 
  the message 3.0/4.0, 3.0 receives the 
  message. */
 Prim /(self, numerator):Real !!


/* Less than.  If the argument is less 
  than the receiver, then this method
  returns true.  In the message 14.0<3.0, 
  3.0 is the receiver of the < message and 
  14.0 is the argument.  */
 Prim <(self, y):Boolean !!


/* Less than or equal to.  If the 
  argument is less than or equal to the 
  receiver, then this method returns true. 
  In the message 14.0<=3.0, 3.0 is the 
  receiver of the <= message and 14.0 is 
  the argument. */
 Prim <=(self, y):Boolean !!


/* Equals.  If the receiver is equal to 
  the argument, then this method returns 
  true.  In the message 14.0=3.0, 14.0 is 
  the receiver of the = message and 3.0 is 
  the argument.  */
 Prim =(self, y):Boolean !!


/* Greater than.  If the argument is 
  greater than the receiver, then this 
  method returns true.  In the message
  14.0>3.0, 3.0 is the receiver of the > 
  message and 14.0 is the argument.  */
 Prim >(self, y):Boolean!!


/* Greater than or equal to.  If the 
  argument is greater than or equal to the 
  receiver, then this method returns true. 
  In the message 14.0>=3.0, 3.0 is the 
  receiver of the >= message and 14.0 is 
  the argument. */
 Prim >=(self, y):Boolean !!


/* Return the arcTangent of the receiver. 
  The receiver is treated as an angle in 
  radians. */
Prim arcTan(self):Real!!


/* Return the receiver as a Long 
  integer.  For example, asLong(38.78) 
  returns 38L.  */
 Prim asLong(self):Long !!


/* Return the receiver as a String.  The
  argument, sigDigits, determines how
  many significant digits are used to make
  the string.  For example, asString(pi,8)
  returns "3.1415927", whereas
  asString(pi,4) returns "3.142".  */
Prim asString(self, sigDigits):String!!


/* Return the cosine of the 
  receiver.  The receiver is treated as an 
  angle in radians. */
Prim cos(self):Real!!


/* Return the sine of the 
  receiver.  The receiver is treated as an 
  angle in radians. */
Prim sin(self):Real!!


/* Return the tangent of the 
  receiver.  The receiver is treated as an 
  angle in radians. */
Prim tan(self):Real!!

/* Return the exponential of the
  receiver (e raised to the self power). */
Prim exp(self):Real!!


/* Return the natural logarithm 
  (base e) of the receiver. */
Prim log(self):Real!!


/* Print the receiver onto the specified
  stream.  */
Prim printOn(self, aStrm):Self!!


/* Return aNum raised to the receiver 
  power as a Real.  For instance, pwr(3.0,
  2.0) returns 8.0.  */
Prim pwr(self, aNum):Real!!


/* Return the square root of the 
  receiver. */
Prim sqrt(self):Real!!


/* Not equal.  If the receiver is not 
  equal to the argument, then this method 
  returns true. In the message 14.0<>3.0, 
  3.0 is the receiver of the <> message and
  14.0 is the argument. */
 Prim <>(self, y):Boolean !!
