/* A Stream holds any indexed collection along with an integer pointer
 which points to the current position in the collection.  Streams
 are used extensively in the compilation process, but they are also
 used in a lot of other places.  For instance, most output in Actor
 is done with Streams (using the various printOn methods).  */!!

/* inherit(Object, #Stream, #(collection position), nil, nil) */!!

now(class(Stream)) !!

now(Stream)!!

/* Return true if the receiver's
  position points to the end of the
  collection.  */
Prim atEnd(self):Boolean!!


/* Return all the elements in the Stream's
  collection from start to stop-1,
  inclusive.  Example:
  copyFrom(streamOver("Hello"),0,3) returns
  "Hel".  */
Prim copyFrom(self, start, stop):Collection!!


/* Return the element of the Stream's
  collection currently being pointed to
  and increments the position pointer.  */
Prim next(self):AnElement!!


/* Place anElement into the Stream's
  collection at the index currently pointed
  to by position, and then increments
  position.  */
Prim nextPut(self, anElement):Stream!!


/* Place aColl into the Stream's
  collection at the index currently pointed
  to by position.  Equivalent to the
  following message: do(aColl,{using(el)
  nextPut(aStrm,el)}).*/
 Prim nextPutAll(self, aColl):Stream !!


/* Place anElement into the Stream's
  collection at the specified offset. Does
  not modify the position instance
  variable.  Equivalent to the following
  construct: aStrm.collection[offSet] :=
  anElement. */
Prim put(self, anElement, offSet):AnElement!!


/* Decrements position instance variable
  if position is zero.  If it is, position
  is not decremented.  Return the new
  value of position.  */
Prim putBack(self):Int!!


/* Set position pointer equal to zero.  */
 Prim reset(self):Stream!!

/* Return the next word from the Stream.
  word is limited to Stream objects where
  the collection is a String.  First, aStrm
  is scanned until it finds the first
  character which is not a delimiterChar.
  It continues scanning until it finds
  another delimiterChar, and the characters
  in between--a word--are returned in the
  form of a String.  The position instance
  variable is updated to the point where
  the delimiterChar was found.  Note: this
  method does not check to see if it is
  looking at valid elements of the Stream.
  If asked, it will search past the end of
  the Stream's collection.  You need to
  check that the Stream is not at the end
  before sending a word message.  */
 Prim word(self, delimiterChar):String!!

/* Return the last element of the Stream's
  collection accessed.  Equivalent to the
  expression aStrm.collection[aStrm.position-1]. */
Prim last(self):AnElement!!