/* A String is a collection of Char objects.  Actor Strings are limited
  in size only by available memory and the maximum object size of 16K-1
  characters.  */!!

/* inherit(ByteCollection, #String, nil, nil, nil);*/ !!

now(StringClass);!!

now(String);!!

/* Draw the string on the current set
 of output ports. */
Def print(self)
{ do(OutPorts,
  {using(port)
    printString(port,self);
  });
}!!

/* Open and compile the file named by self. */
Def  load(self)
{       ^load(Source, self);
} !!

/* Convert delimiters to spaces. */
Def  mapDelims(self)
{  ^map(self,
	{using(ch) max(ch, ' ');
   });
} !!

/* Look for an end-of-comment "symbol" in the receiver string.
  If one is found, return a number one greater than the index
  of where the end-of-comment symbol is located. */
Def commentBreak(self | pos)
{
  if pos := find(self, "*/", 0)
  then ^pos + 2;
  endif;
  ^nil
}!!


/* Break self into lines according width.  Ignore level. 
  Used by Actor edit windows for displaying long object
  representations. */
Def breakLines(self, lev, width | anOc, pos, str)
{ anOc := new(OrderedCollection, 2);
  pos := findBreak(self, width);
  add(anOc, subString(self,0,pos));
  str := self;
  loop  str := leftJustify(delete(str, 0, pos));
  while  limit(str) > width
  begin  pos := findBreak(str, width);
    add(anOc, subString(str, 0, pos));
  endLoop;
  if limit(str) > 0
  then add(anOc, str);
  endif;
  ^anOc
}!!

/*  Find and return a sensible break point in a string.
  Used by method formattter. */
Def findBreak(self, len)
{
  if limit(self) <= len
  then ^limit(self);
  endif;
  do(overBy(len, 0, -1),
  { using(idx | ch)
    if (ch := self[idx]) == ' ' or ch == ','
    then  ^min(idx+1, len);
    endif;
  });
  ^len
}!!


/* Create and return a new Stream whose collection is the receiver
  String and whose position is set to zero.  */
Def streamOver(self | aStrm)
{       (aStrm := new(Stream)).collection := self;
        ^reset(aStrm);
}!!

/* Return the number of leading blanks. */
Def  leadingBlanks(self)
{^size(self) - size(leftJustify(self));
}!!

/* Return a new string with aStr inserted at the specified index. */
Def  insert(self, aStr, idx)
{  ^replace(self:String, aStr, 0, limit(aStr), idx, idx);
} !!

/* String concatenate operation.  */
Prim +(self, aStr):String!!

/* Return a new string with leading blanks removed.   */
Def    leftJustify(self | strm, wrd)
{ strm :=  streamOver(self);
  if wrd := word(strm, ' ')
  then   ^replace(self:String,
      "", 0, 0, 0, (strm.position - limit(wrd))-1);
  endif;
  ^""
}!!

/* Return a new string, with the characters from begIdx to
  endIdx-1, inclusive, removed from self.  */
Def delete(self, begIdx, endIdx)
{   ^replace(self:String, "", 0, 0, begIdx, endIdx);
}!!

/* Return a new string, with the characters from self[begIdx] to
  self[endIdx-1], inclusive.  */
Def subString(self, begIdx, endIdx)
{   ^replace("", self, begIdx, endIdx, 0, 1);
}!!

/* Show an error box with self as the caption, and str as the message.  */
Def errorBox(self, str)
{       new(ErrorBox, ThePort, str, self, 0);
}!!

/* Return a new string from 0 to the first null in the receiver. */
Def  removeNulls(self | idx)
{  if (idx := indexOf(self, asChar(0), 0))
        then ^subString(self, 0, idx);
   endif;
} !!

/* Return a literal object if self contains one.
  For instance, asLiteral(" 3@2 Hello ") would return
  the Point object 3@2.  */
Def asLiteral(self | lex)
{ lex := new(ActorAnalyzer);
  lex.collection := self;
  reset(lex);
  if getToken(lex) == LITERAL
  then ^lex.val;
  else ^nil;
  endif;
}!!

/* Return an upper-case version of the receiver. */
Def asUpperCase(self)
{ ^map(self,
  {using(ch) asUpperCase(ch)
  });
}!!


/* Return a new string with all trailing blanks removed. */
 Def rightJustify(self | idx)
{ idx := limit(self);
  loop
  while idx > 0
  begin
    if self[idx-1] ~= ' '
    then ^subString(self, 0, idx);
    endif;
    idx := idx-1;
  endLoop;
  ^"";
}  !!

/* Return true if aStr precedes self alphabetically. */
Prim <(self, aStr):Boolean!!

/* Return true if two strings are identical.  Note that
  <> is NOT defined, so use not(str1 = str2) instead. */
Prim =(self, aStr):Boolean!!

/* Return true if aStr follows self alphabetically.  */
Prim >(self, aStr):Boolean !!

/* Append a 0 byte to the end of this string, return new string.
  MS-Windows usually requires such a "null-terminated" string. */
Prim asciiz(self):string !!

/* Return a MS-Windows handle for self.  The string is copied
  to global memory and a handle is obtained.  Later, the handle
  should be freed using GlobalFree, otherwise global memory is
  used up. */
Prim asHandle(self):handle !!


/* Return the value of number in self, according to base.
  For example, asInt("FF", 16) returns 255.  */
Prim asInt(self, base):Int !!

/* Return the value of number in self as a Real.
  For example, asReal("3.4") returns 3.4.  */
Prim asReal(self):Real!!

/* Return self--dummy conversion. */
Prim asString(self):String!!

/* Return self represented as a symbol. */
Prim asSymbol(self):Symbol!!


/* Return the character at the specified index (self[idx]). */
Prim at(self, idx):Char!!

/* Equivalent to the subString method--return new string
  from begIdx to endIdx-1, inclusive. */
Prim copyFrom(self, begIdx, endIdx):String!!

/* Erase self (fills with blanks).  Does not produce a new string.
  For instance, erase("aaaaa") returns "     ".  */
Prim erase(self):String!!

/* Fill self with aChar.  Does not produce a new string.
  For example, fill("Hello", 'a') returns "aaaaa".  */
Prim fill(self, aChar):String!!

/* Find and return the index of the first occurence of targetStr in
  self, starting at idx.  Return nil if not found. */
Prim find(self, targetStr, idx):Int!!

/* Return the hash value of self. */
Prim hash(self):Int!!

/* Find and return the index of the first occurence of targetChar in
  self, starting at idx.  Return nil if not found. */
Prim indexOf(self, targetChar, idx):Int !!

/* Return Boolean true if self is a symbol. */
Prim isSymbol(self):Boolean !!

/* Print the receiver string onto the specified
  stream. */
Prim printOn(self, aStrm):self !!

/* Return a new string, deleting the target range from self and
  replacing with source range.  This method is used
  by insert, delete, subString, copyFrom, etc. */
Prim replace(self, source, srcBegIdx, srcEndIdx, targBegIdx, targEndIdx):String !!

/* sysPrint the receiver string onto the specified
  stream. */
Prim sysPrintOn(self, aStrm):self !!

/* Place the specified character into self at idx.
  For example, put("Hello", 'J', 0) returns "Jello".
  Return the altered string.  */
Prim put(self, char, idx):self !!

/* Assuming receiver is valid Actor source code,
  compile receiver into a temporary function and
  execute that function.  This is the method used
  by Actor when you highlight a string and select
  Doit! from the menu--the highlighted range is
  sent a parse message.  Actually uses
  YaccMachine:parse. */
Prim parse(self):Object!!