/* Assembly Line Window class file created 10-14-86  */!!

inherit(DDEWindow, #PAWindow, #(cycle, progress, wedge, conveyor, hnd,
                              QAhWnd, paAtom, dimAtom, newBatchAtom, done,
			      dimOk, newOk),
        nil, nil);!!

now(PAWindowClass);!!

now(PAWindow);!!

/* initialize ivars, executed when window is created */
Def init(self)
  {init(self:DDEWindow);
  wedge  := new(Wedge);
  init(wedge,20,6);
  conveyor := new(Conveyor);
  init(conveyor);
  cycle  := 0;
  progress := -1;
  QAhWnd  := 0L;
  paAtom := addAtom(self, "PAdata");
  dimAtom  := addAtom(self, "Dimensions");
  newBatchAtom := addAtom(self, "NewBatch");
  dimOk := nil;
  newOk := nil;
  done  := 0;
  putWord(paintStruct, 1, 2);
  ^0
  }!!

/* send widgets dimensions as they are measured 
*/Def sendMeasures(self | ht, lg, wd, aStr, hStr)
  {ht := random(41) - 20;
  lg := random(41) - 21;
  wd := random(40) - 20;
  aStr := asString(ht,10)+" "+asString(lg,10)+" "+asString(wd,10);
  hStr := asHandle(aStr);
  postMessage(self, QAhWnd, WM_DDE_DATA, hWnd,   
  pack(dimAtom, hStr),"[From]PA [To]QA [Msg]Dimensions");
  ^0
  }!!

/* post message when new batch is run */
Def newBatch(self)
  {postMessage(self, QAhWnd, WM_DDE_DATA, hWnd, 
  pack(newBatchAtom, 0), "[From]PA [To]QA [Msg]NewBatch");
  ^0
  }!!

/* draws the conveyor, cutter and boxes */
Def fill(self, hdc | outwidth)
  {setGraphicsMode(self, hdc);
  outwidth := width(outline);
  if (cycle = 0)
  then shift(wedge, 120, 50, 120, 70, color[2], color[4], hdc);
  else fill(wedge, 120, 50, color[2], color[4], hdc);
  endif;
  refill(conveyor, done, cycle, color, hdc);
  ^0
  }!!

/* program loop to simulate Real-Time App */
Def nextLoop(self | hdc)
  {if (newOk == nil)
  then mprint(self:DDEWindow,"[PA]QA not ready to receive new batch.");
       postMessage(self, QAhWnd, WM_DDE_ADVISE, hWnd, pack(0, newBatchAtom),
          "[From]PA [To]QA [Msg]NewBatch");
    ^0
  endif;
  if (dimOk == nil)
  then mprint(self:DDEWindow,"[PA]QA not ready to receive dimensions");
       postMessage(self, QAhWnd, WM_DDE_ADVISE, hWnd, pack(0, dimAtom),
          "[From]PA [To]QA [Msg]Dimensions");
    ^0
  endif;
  progress := progress + 4;
  cycle   := cycle + 4;
  if      (cycle >= 40)
  then    cycle   := 0;
  endif;
  refresh(self);
  if      (cycle = 0)
  then
    if (done = 0)
    then newBatch(self);
    endif;
    done := done + 1;
    sendMeasures(self);
    if (done >= 25)
    then done := 0;
      clearLine(self);
    endif;
  endif;
  ^0
  }!!

/* clear the assembly line */
Def clearLine(self | hdc)
  {hdc := getContext(self);
  setGraphicsMode(self, hdc);
  clearLine(conveyor, color[4], hdc);
  releaseContext(self, hdc);
  ^0
  }!!
 
/* starts the whole job running */
Def start(self)
  {paAtom := addAtom(self,"PAdata");
  sendMessage(self, 0xFFFFL, WM_DDE_INITIATE, hWnd, pack(0, paAtom),
  "[From]PA [To]All [Msg]PAdata");
  deleteAtom(self, paAtom);
  Call SetTimer(hWnd, 0x17, 50, 0);
  ^0
  }!!

/* timer is put into place to execute nextLoop 
at regular intervals */Def WM_TIMER(self, wp, lp)
  {Call KillTimer(hWnd,0x17);
  if (QAhWnd = 0L)
  then paAtom := addAtom(self, "PAdata");
    mprint(self:DDEWindow,"[PA]No response from QA window.");
    sendMessage(self, 0xFFFFL, WM_DDE_INITIATE, 
    hWnd, pack(0, paAtom), "[From]PA [To]All [Msg]PAdata");
    deleteAtom(self,paAtom);
    Call SetTimer(hWnd, 0x17, 50, 0);
  else nextLoop(self);
    Call SetTimer(hWnd, 0x17, 50, 0);
  endif;
  ^0
  }!!

/* method to redraw screen */
Def paint(self, hdc)
  {setGraphicsMode(self, hdc);
  refill(conveyor, done, cycle, color, hdc);
  ^0
  }!!

/* DDE message to acknowledge receipt of messages */
Def WM_DDE_ACK(self, wp, lp | look, okay)
  {look := high(lp);
  okay := nonZero(low(lp) bitAnd 0x8000);
  if ((look = paAtom) and okay)
  then if (QAhWnd = 0)
       then QAhWnd := wp;
            mprint(self:DDEWindow,"[PA]received WM_DDE_ACK for WM_DDE_INITIATE");
       else mprint(self:DDEWindow,"[PA]request already handled.");
       endif;
  else select
       case ((look = dimAtom) and okay)
           mprint(self:DDEWindow,"[PA]received WM_DDE_ACK for ADVISE of Dimensions");
           dimOk := 1;
       endCase;
       case ((look = dimAtom) and (okay == nil))
           mprint(self:DDEWindow,"[PA]received WM_DDE_ACK/could not send Dimensions");
           dimOk := nil;
       endCase;
       case ((look = newBatchAtom) and okay)
           mprint(self:DDEWindow,"[PA]received WM_DDE_ACK for ADVISE of New Batch");
           newOk := 1;
       endCase;
       case ((look = newBatchAtom) and (okay == nil))
           mprint(self:DDEWindow,"[PA]received WM_DDE_ACK/could not send New Batch");
           newOk := nil;
       endCase;
       endSelect;
  endif;

  deleteAtom(self, low(lp));
  deleteAtom(self, high(lp));
  ^0
  }!!

                                                                                                         