;**  BRIEF macro file to convert the output of yacc ("xxx.c")
;**  to Actor source code.	 You should change the name 
;**  "TParser", below, to the global variable that will hold
;**  your parser object. This file can then be loaded. 
;**  The parser's instance variables,
;**  inherited from YaccMachine, are initialized to the arrays
;**  produced by running yacc on your grammar.
;**  C.B. Duff  12.12.86


( macro	gen_yacc
	(
		(drop_anchor)
		(search_fwd "CODE 256")
		(end_of_line)
		(cut)

		(search_fwd "YYFLAG")
		(beginning_of_line)
		(drop_anchor)
		(search_fwd "switch(yym)")
		(delete_line)
		(delete_line)
		(cut)

		(top_of_buffer)
		(translate "short " "TParser." 1)
		(translate "\\[\\]=\\{" " := #("	1)
		(translate "\\[\\] =\\{" " := #("	1)
		(translate "# " "#" 1)
		(translate "{*}," "\\0 " 1)

		(search_fwd "YYNPROD")
		(end_of_line)
		(insert "!!")

		(search_fwd "YYLAST")
		(next_word)
		(left)
		(drop_anchor)
		(beginning_of_line)
		(cut)
		(insert "TParser.yylast := ")
		(end_of_line)
		(insert "!!")
		(top_of_buffer)

		(while  (search_fwd "\\}\\;")
			( 
				(delete_to_eol)
				(insert "\)!!" )
			)
		) 
		(search_fwd "case")
		(insert "TParser.yyActions := new(Array,YYNPROD)!!\n")
		(actions)
	)	 
)	

( macro actions
	( 	
		(while	
				(search_fwd "[0-9]@:")
			(
				(drop_anchor)
				(end_of_line)
				(left)
				(left)
				(copy)
				(delete_line)
				(delete_line)
				(beginning_of_line)
				(delete_char)
				(delete_char)
				(insert "TParser.yyActions\[")
				(paste)
				(insert "\] := #")
				(search_fwd "}" 0)
				(delete_to_eol)
				(insert "!!")
			)
		)
		(drop_anchor)
		(end_of_buffer)
		(cut)
	)
)
			
                                             