/* A reorder window displays a view of the videos needing reorder. */!!

inherit(TextWindow, #ReorderWindow, nil, 2, nil)!!

now(class(ReorderWindow))!!

now(ReorderWindow)!!

/* Properly handle resizing of the window. */
Def reSize(self, wp, lp | extra)
{ tmWidth cor init(self);
  if (lp <> 0L) cand (wp == SIZENORMAL cor 
    wp == SIZEFULLSCREEN)
  then xMax := right(clientRect(self)) / tmWidth - 1;
  endif; 
}!!

/* Responds to the Print menu selection by printing
the contents of the window. */
Def printCommand(self | prn)
{ prn := new(Printer);
  getPrinterParms(prn);
  if deviceMode(prn, self) 
  then if start(prn, "Reorder View", self)
    then
      do(workText(self),
      {using(aLine) printLine(prn, aLine);
      });
      finish(prn);
    else new(ErrorBox, self, "Printer not ready", 
      "VideoMATIC", MB_OK bitOr MB_ICONEXCLAMATION);
    endIf;
  endIf;
}
!!

/* Processes the menu selections by automatically 
sending the corresponding message. */
Def command(self, wP, lP | msg)
{ if msg := action(menu, wP)
  then ^perform(self, msg);
  endif; 
}!!

/* Initializes the new reorder window object by 
  building its menu. */
Def init(self | act1)
{ init(self:ancestor);
  menu := create(new(Menu), self);
  act1 := new(MenuItem, "&Print", 501, #printCommand);
  addItem(menu, act1);
  drawMenu(self);
}
!!