	TITLE	'DEFAULT CONSOLE BAUD RATE DATA TABLE'
;
; THIS DATA RESIDES IN A DISK FILE NAMED CONBAUD.SYS.  UPON COLD
; BOOT THE LOADER SEARCHES FOR A FILE NAMED CONBAUD.SYS AND USES
; THE DATA IN THAT FILE TO INITIALIZE THE CONSOLE DEVICE.
;


; ZILOG COUNTER TIMER (CTC) HARDWARE PORT LOCATIONS:

CTC0	EQU	8		; CTC CHANNEL 0
CTC1	EQU	CTC0+1		; CTC CHANNEL 1
CTC2	EQU	CTC1+1		; CTC CHANNEL 2
CTC3	EQU	CTC2+1		; CTC CHANNEL 3

; COUNTER TIMER CHANNEL INITIALIZATION CONTROL WORDS:

CCCRSET	EQU	00000010B	; SOFTWARE CHANNEL RESET
				; BIT 1 = RESET

CCCINI0	EQU	01000101B	; INIT WORD FOR CHANNEL 0
				; BIT 0 = CONTROL WORD
				; BIT 2 = TIME CONSTANT FOLLOWS
				; BIT 3 = AUTO TRIGGER
				; BIT 5 = PRESCALE 16 (NA FOR COUNTER)
				; BIT 6 = COUNTER MODE
				; BIT 7 = DISABLE INTERRUPTS

CCCINI1	EQU	CCCINI0		; INIT WORD FOR CHANNEL 1

CCCINI2	EQU	CCCINI0		; INIT WORD FOR CHANNEL 2

CCCINI3	EQU	00100101B	; INIT WORD FOR CHANNEL 3
				; BIT 0 = CONTROL WORD
				; BIT 2 TIME CONSTANT FOLLOWS
				; BIT 3 = AUTO TRIGGER
				; BIT 5 = PRESCALER
				; BIT 6 = TIMER MODE
				; BIT 7 = ENABLE INTERRUPTS

; COUNTER TIMER CHANNEL TIME CONSTANTS FOR BAUD RATES:

CCCTC384	EQU	00000001B	; TIME CONSTANT = 38.4K BAUD*32
CCCTC192	EQU	00000010B	; TIME CONSTANT = 19.2K BAUD*32
CCCTC96		EQU	00000100B	; TIME CONSTANT = 9600 BAUD*32
CCCTC48		EQU	00001000B	; TIME CONSTANT = 4800 BAUD*32
CCCTC24		EQU	00010000B	; TIME CONSTANT = 2400 BAUD*32
CCCTC12		EQU	00100000B	; TIME CONSTANT = 1200 BAUD*32
CCCTC6		EQU	01000000B	; TIME CONSTANT = 600 BAUD*32
CCCTC3		EQU	10000000B	; TIME CONSTANT = 300 BAUD*32
CCCTC1$5	EQU	10000000B	; TIME CONSTANT = 150 BAUD*64
CCCTC1$1	EQU	174		; TIME CONSTANT = 110 BAUD*64


; CRT DEFINITIONS:

CRTDAT	EQU	00H		; DATA PORT
CRTSTS	EQU	CRTDAT+1	; STATUS PORT
CRTCTL	EQU	CRTSTS		; CONTROL PORT
CRTDAV	EQU	01H		; RECEIVER DATA AVAILABLE MASK
CRTTBE	EQU	04H		; TRANSMIT BUFFER EMPTY MASK

; (DART) INITIALIZATION CONSTANT FOR WR0, RESET &  REGISTER SELECT.

CCSRESET	EQU	00011000B	; SOFTWARE CHANNEL RESET
					; BIT 1 = SOFTWARE RESET
CCSWRSL0	EQU	00010000B	; WRITE REGISTER SELECT #0
CCSWRSL1	EQU	00000001B	; WRITE REGISTER SELECT #1
					; ? I COPIED FROM JRS'S CODE FOR ABOVE
CCSWRSL2	EQU	00010010B	; WRITE REGISTER SELECT #2
CCSWRSL3	EQU	00010011B	; WRITE REGISTER SELECT #3
CCSWRSL4	EQU	00010100B	; WRITE REGISTER SELECT #4
CCSWRSL5	EQU	00010101B	; WRITE REGISTER SELECT #5
CCSRSTAT	EQU	00010000B	; RESET EXT/STATUS INTERRUPTS
					; USE TO READ BACK STATUS OF
					; DCD & CTS PINS.

; (DART) INITIALIZATION CONSTANT FOR WR1, INTERRUPT CONTROL.

CCSINTIN	EQU	00011000B	; COPIED JRS'S CODE
					; BIT 0 = EXT INT ENABLE
					; BIT 1 = TX INT ENABLE
					; BIT 2 = STATUS AFFECTS VECTOR
					; BIT 3 & 4
					; 00 = RX INT DISABLE
					; 01 = RX INT ON 1ST CHAR
					; 10 = INT ON ALL RX CHAR, PARITY SETS VECTOR
					; 11 = INT ON ALL RX CHAR, PARITY NA ON VECTOR
					; BIT 5 = WAIT/READY ON R/T
					; BIT 6 = WAIT/READY FUNCTION
					; BIT 7 = WAIT/READY ENABLE

; (DART) INITIALIZATION CONSTANT FOR WR2, INTERRUPT VECTOR (CH B ONLY).

; (DART) INITIALIZATION CONSTANT FOR WR3, RECIEVER DATA.

CCSRXINI	EQU	11000001B	; 8 DATA BITS, INTERRUPTS
					; BIT 0 = RX ENABLE
					; BIT 1,2,3,4 = UNUSED
					; BIT 5 = AUTO ENABLE
					; BIT 6 & 7
					; 00 = RX 5 BITS/CHAR
					; 01 = RX 7 BITS/CHAR
					; 10 = RX 6 BITS/CHAR
					; 11 = RX 8 BITS/CHAR

; (DART) INITIALIZATION CONSTANT FOR WR4, CLOCKING & PARITY.

CCSCKINI	EQU	10000100B	; 32X CLOCK, 1 STOP BIT, NO PARITY
					; BIT 0 = PARITY ENABLE
					; BIT 1 = PARITY EVEN/*ODD
					; BIT 2 & 3
					; 00 = UNUSED
					; 01 = 1 STOP BIT
					; 10 = 1 1/2 STOP BITS
					; 11 = 2 STOP BITS
					; BIT 4 = UNUSED
					; BIT 5 & 6
					; 00 = 1X CLOCK RATE
					; 01 = 16X CLOCK RATE
					; 10 = 32X CLOCK RATE
					; 11 = 64X CLOCK RATE

; (DART) INITIALIZATION CONSTANT FOR WR5, TRANSMITTER DATA.

CCSTXINI	EQU	11101010B	; DTR, TX 8 BITS, TX ENABLE, RTS
					; BIT 0 = UNUSED
					; BIT 1 = RTS
					; BIT 2 = UNUSED
					; BIT 3 = TX ENABLE
					; BIT 4 & 5
					; 00 = TX 5 BITS
					; 01 = TX 7 BITS
					; 10 = TX 6 BITS
					; 11 = TX 8 BITS
					; BIT 7 =  DTR

; DEFAULT CONSOLE INITIALIZATION TABLE
		ORG	100H		; TO MAKE LOAD HAPPY


CLTBL	EQU	$		; CONSOLE/LIST DEVICES -- INITIALIZATION
				; STREAM TABLE.

	DB	SIZE2,CTC0	; CTC CHANNEL 0 (DART A BAUD RATE)
J	SET	$
	DB	CCCINI0		; CTC CHANNEL 0 INTIALIZATION WORD
	DB	CCCTC96		; CONSOLE BAUD RATE OF 9600.
SIZE2	EQU	$-J

	DB	SIZE1,CRTCTL	; SIO # 1 CHANNEL A
J	SET	$
	DB	CCSRESET	; RESET CHANNEL.
	DB	CCSWRSL4	; SELECT WRITE REGISTER 4.
	DB	CCSCKINI	; 32X CLOCK, 1 STOP BIT, NO PARITY.
	DB	CCSWRSL3	; SELECT WRITE REGISTER 3
	DB	CCSRXINI	; RX 8 BITS, NO HANDSHAKING, RX ENABLE.
	DB	CCSWRSL5	; SELECT WRITE REGISTER 5
	DB	CCSTXINI	; DTR, TX 8 BITS, TX ENABLE, *RTS LOW.
	DB	CCSWRSL1	; SELECT WRITE REGISTER 1.
	DB	0		; NO INTERRUPTS
SIZE1	EQU	$-J
	DB	0		; TERMINATE TABLE
	END
