
					// CSXFORM.BCPL - color space transforms

			//** Translated roughly from BCPL by bcpl2c.pl, 10/5/2005


#include "G06DEFS.H"
#include "IOX.H"

extern void HSBRTORGB();
extern void RGBTOHSBR();

#define maxv 255		// originally 1023, 9/05 rgs


        void RGB(word *B, int X, int Y, int Z) 
			{ B[1]=X; B[2]=Y; B[3]=Z; }
        
				void HSBRTORGB(word *A, word *B) 
					{/*H*/ 
                   		//       THIS ROUTINE ASSUMES H,S,AND BR (ON THE RANGE 0-1023)
                   		//       ARE STORED IN WORDS 1-3 OF VECTOR A.   IT RETURNS
                   		//       THE EQUIVALENT R,G,AND B (ALSO ON THE RANGE 0-1023) IN
                   		//       WORDS 1-3 OF VECTOR B.   A & B CAN BE THE SAME VECTOR.
                   int H,S,BR,M,N,HR,HQ;

                   FLDI(1,maxv);
                   FLDI(2,100);
                   FLDI(3,60);
                   FLDI(4,360);


                   FLDI(6,A[1]);
                   FML(6,4); FDV(6,1);
                   H = FTR(6); if (H == 360) H = 0;    	// 0 LE H LS 360

                   FLDI(7,A[2]);
                   FML(7,2); FDV(7,1);
                   S = FTR(7);                          // 0 LE S LE 100

                   FLDI(8,A[3]);
                   BR = FTR(8);                         // 0 LE BR LS 1024

                   HR = H%60; HQ = H/60;

                   FLD(9,8); FLD(11,8); FML(11,7); FDV(11,2); FSB(9,11); M = FTR(9);

                   FLD(10,8); FLDI(12,HR); FML(12,11); FDV(12,3); FSB(10,12); N = FTR(10);

                   switch (HQ) 
                   {        case 0: { RGB(B,BR,N,M); break; }
                            case 1: { RGB(B,BR,M,M+BR-N); break; }
                            case 2: { RGB(B,N,M,BR); break; }
                            case 3: { RGB(B,M,M+BR-N,BR); break; }
                            case 4: { RGB(B,M,BR,N); break; }
                            case 5: { RGB(B,M+BR-N,BR,M); break; }
                   }
         }/*H*/ 


        void HUE(M,N,P) 
          { FLDI(14,M);                       		// FTR(14) WOULD GIVE HBASE
            FML(N,P); FDV(N,15); FLD(6,N);    		// FTR(6) WOULD GIVE HREL
          }

         void RGBTOHSBR(word *A, word *B) 
         {/*R*/ 
                  		//      THIS ROUTINE ASSUMES R,G,B (ON THE RANGE 0-1023) ARE STORED
                  		//      IN WORDS 1-3 OF VECTOR A.  IT RETURNS THE EQUIVALENT
                  		//      H,S,BR (ALSO ON THE RANGE 0-1023) IN WORDS 1-3 OF
                  		//      VECTOR B.  A & B CAN BE THE SAME VECTOR.
                  word BT[4];
                  word BR=0, X=maxv, I;

                  for (I=1; I<=3; I++) 
					  if (BR < A[I]) BR = A[I];  // BR=MAX(R,G,B)
                  BT[3] = BR;
                  for (I=1; I<=3; I++) if (X > A[I]) X = A[I];    // X=MIN(R,G,B)
                  if (BR == X) { B[1] = 0;                   // H AND S ARBITRARILY
                                 B[2] = 0;                  // SET TO 0 FOR BR=0
                                 B[3] = BR;                 // OR S=0
                                 return; }

                  FLDI(1,maxv);
                  FLDI(2,100);
                  FLDI(3,60);
                  FLDI(4,360);
                  FLDI(5,-60);

                  FLDI(8,BR);                        		// AC8 HOLDS BR
                  FLDI(9,BR);
                  FLDI(10,X);                        		// AC10 HOLDS X
                  FSB(9,10);
                  FML(9,1);                          		// FML(9,2) AND S=FTR(9) HERE INSTEAD
                                                    		// WOULD GIVE S ON 0-100
                  FDV(9,8);
                  BT[2] = FTR(9);                     		// AC9 HOLDS S (ON RANGE 0-1023)

                  FLDI(11,A[1]); FLDI(12,A[2]); FLDI(13,A[3]);
                  FSB(11,8); FNEG(11);               		// AC11 HOLDS BR-R
                  FSB(12,8); FNEG(12);               		// AC12 HOLDS BR-G
                  FSB(13,8); FNEG(13);               		// AC13 HOLDS BR-B

                  FLD(15,8); FSB(15,10);             		// AC15 HOLDS BR-X


                  if (A[1] == BR) 
						  if (A[3] == X) HUE(0,12,3);
                          else HUE(120,13,5);
                  if (A[3] == BR) 
						  if (A[2] == X) HUE(120,11,3);
                          else HUE(240,12,5);
                  if (A[2] == BR) 
						  if (A[1] == X) HUE(240,13,3);
                          else HUE(360,11,5);
                                                    		// HERE HBASE+HREL WOULD GIVE
                                                    		// H ON THE RANGE 0-360
                  FAD(14,6);
                  FML(14,1); FDV(14,4); BT[1] = FTR(14);
                  B[1] = BT[1]; B[2] = BT[2]; B[3] = BT[3];

 }/*R*/ 

