
          		// G06B.BCPL - GRAPHICS SYSTEM 06

			//** Translated roughly from BCPL by bcpl2c.pl, 9/28/2005

          		// 1/18/75  RGS - PB

          		// modified August 3, 1978 RGS

#include "G06DEFS.H"
#include "IOX.H"
#include "FREEDEFS.H"

int TABGRID=0, GRIDCNT=0;


void G06B_PROG() { }


                   		// ---- TABLET ROUTINES ----

              		//GENERAL CURSOR ROUTINE

void CURSOR(pPOS1,pPOS2ORSTAT,UPMODE,DOWNMODE,CWIN,pCRTAB,NTABS,pCXTAB,NARGS,WAIT)
		POS *pPOS1, *pPOS2ORSTAT; WIN CWIN; RUNCODE *pCRTAB; word *pCXTAB;
   {
	  		// BLACK & RED USUALLY
#define CC1 (1*256)
#define CC2 (2*256) 
    		// DEFAULT BICOLOR TRIANGULAR CURSOR
    word DEFXTAB[] = { 0,0,1,1,2,2,3,3,4,4,4,3,3,2,2,1,1,0,0 };
    		// DEFAULT CURSOR WHEN PEN UP
    word DEFRTAB1[] = { CC1+9,CC1+9,CC1+7,CC1+7,CC1+5,CC1+5,CC1+3,CC1+3,
					  CC1+1,0,CC2+1,CC2+3,CC2+3,CC2+5,CC2+5,
					  CC2+7,CC2+7,CC2+9,CC2+9 };
    		// DEFAULT CURSOR WHEN PEN DOWN
    word DEFRTAB2[] = { CC2+9,CC2+9,CC2+7,CC2+7,CC2+5,CC2+5,CC2+3,CC2+3,
					  CC2+1,0,CC1+1,CC1+3,CC1+3,CC1+5,CC1+5,
					  CC1+7,CC1+7,CC1+9,CC1+9 };
    WIN DEFWIN, *pW=&CWIN; 
	PENSTAT PEN, *pPEN=&PEN;
	swapbytes(&DEFRTAB1,19);		// for i86, 9/05 rgs
	swapbytes(&DEFRTAB2,19);		//

    FILLWIN(7,&DEFWIN,0,0,9,19,4,9);
    if (!WAIT) pPEN = (PENSTAT*)pPOS2ORSTAT;

    		//WHICH CURSOR?
    switch (NARGS) {
       case 2:
       case 4: pW = &DEFWIN;
           pCXTAB = DEFXTAB; NTABS = 1;
           break;
       case 8: break;
       default: ERROR(2,"CURSOR ROUTINE",0);
       }

   do { READTABLET(pPOS1,pPEN);
     SOFTGRIDPT(pPOS1,pPOS1);
     pW->YORIG = pPOS1->Y;
     pW->XORIG = pPOS1->X;
     if (NARGS < 8) pCRTAB = (RUNCODE*)(pPEN->DOWN ? DEFRTAB2:DEFRTAB1);
     if (pPEN->PROX) RUNTABSTOPM(5,*pW,pCRTAB,NTABS,UPMODE,pCXTAB);
     if (!WAIT) return; 
        } while (!(pPEN->PUSH && pPEN->PROX));

	READTABLET(pPOS2ORSTAT,pPEN); 
	}

          
	void TABLETSTROKE(N,pP1,pP2,UPMODE,DOWNMODE,CWIN,pCRTAB,NTABS,pCXTAB) 
		POS *pP1, *pP2; WIN CWIN; RUNCODE *pCRTAB; word *pCXTAB;
		  {
               POS P; PENSTAT S;

               do READTABLET(&P,&S); while (S.DOWN);
               switch (N) 
               { case 1: pP2 = &P; N = 2;
                 case 2: UPMODE = OVBOTHQ;
					     DOWNMODE = OVBOTHQ;
                 case 4: break;
                 case 8: break;
                 default: ERROR(2,"TABLETSTROKE",0); };

               CURSOR(pP1,pP2,UPMODE,DOWNMODE,CWIN,pCRTAB,NTABS,pCXTAB,N,TRUE);
               GRIDPT(pP1,pP1);
               GRIDPT(pP2,pP2);
          }

           
	void TABLETTRACK(N,pP1,pSTAT,UPMODE,DOWNMODE,CWIN,pCRTAB,NTABS,pCXTAB) 
		POS *pP1; PENSTAT *pSTAT; WIN CWIN; word *pCRTAB, *pCXTAB;
			{
               PENSTAT S;

               switch (N) 
               { case 1: pSTAT = &S; N = 2;
                 case 2: UPMODE = OVBOTHQ;
						 DOWNMODE = OVBOTHQ;
                 case 4: break;
                 case 8: break;
                 default: ERROR(2,"TABLETTRACK",0); };
               CURSOR(pP1,pSTAT,UPMODE,DOWNMODE,CWIN,pCRTAB,NTABS,pCXTAB,N,FALSE);
               GRIDPT(pP1,pP1);
               }


                          		// DEFINE A RECTANGLE ON TABLET
                          		// 1/21/75

           word GETRECT(N,pWIN,MODE) 
			   WIN *pWIN;
             {/*GETR*/ 
#define CSIZE 100 
               POS POINT;
               PENSTAT PEN;
               byte TC=0, C0=1, C1=1, C2=2, C3=0, TCT;
               byte OLDV0 = VALTRANSTAB[C0].VALUE;
               RUNCODE CRUNTAB[CSIZE];
               word CXTAB[CSIZE];
               WIN CWIN;
               word X, Y, H, W, I;

               if (N == 1) MODE = OVBOTHQ;
               FILLWIN(7,&CWIN,0,0,CSIZE,CSIZE,2,2);

               CRUNTAB[0].VALUE = C0;
               CRUNTAB[1].VALUE = C0;
               CRUNTAB[0].RUN = CSIZE-1;
               CRUNTAB[1].RUN = CSIZE-1;
               for (I=2; I<=CSIZE-1; I++)
                  { CRUNTAB[I].VALUE = C0;
                    CRUNTAB[I].RUN = 2; }

               READTABLET(&POINT,&PEN);    		// IN CASE ALREADY DOWN
               do { READTABLET(&POINT,&PEN);
                Y = POINT.Y; X = POINT.X;
                CWIN.YORIG = Y; CWIN.XORIG = X;
                SETVALTRANSTAB(2,C0,C1);
                TC = TC+1;
                if (TC > 8)
                 { C3=C1; C1=C2; C2=C3; TC=0; }
                if (PEN.PROX)
                   RUNTABSTOPM(4,CWIN,CRUNTAB,1,MODE);
                } while (!(PEN.PUSH && PEN.PROX));

               VALTRANSTAB[C0].VALUE = OLDV0; VALTRANSTAB[C0].ISNULL = FALSE;
               switch (FINDMENU(POINT,DEFMENU,DEFMENULEN)) 
                { default:
                  case 0: return (FALSE); break;
                  case 1: FILLWIN(7,pWIN,PMXMID,PMYMID,PMWIDTH,PMHEIGHT,PMXMID,PMYMID);
                     return (TRUE); break;
                  case 2: break;
                            }
               FILLWIN(7,pWIN,X,Y,1,1,0,0);
               CRUNTAB[CSIZE-1].VALUE = C0;
               CRUNTAB[CSIZE-2].VALUE = C0;
               CRUNTAB[1].VALUE = C0;
               CRUNTAB[0].VALUE = C0;
               CRUNTAB[CSIZE-1].RUN = CSIZE-1;
               CRUNTAB[CSIZE-2].RUN = CSIZE-1;
               CRUNTAB[1].RUN = 2;
               CRUNTAB[0].RUN = 2;
               for (I=0; I<=CSIZE-3; I++) CXTAB[I] = CSIZE-3;
               CXTAB[CSIZE-2] = 0; CXTAB[CSIZE-1] = 0;
               FILLWIN(7,&CWIN,CWIN.XORIG,CWIN.YORIG,
                  CSIZE,CSIZE,CSIZE-2,CSIZE-2);

               do READTABLET(&POINT,&PEN); while (PEN.DOWN);
               do { READTABLET(&POINT,&PEN);
                Y = POINT.Y; X = POINT.X;
                CWIN.YORIG = Y; CWIN.XORIG = X;
                SETVALTRANSTAB(2,C0,C1);
                TCT = (Y > pWIN->YORIG) && (X > pWIN->XORIG);
                TC = TC + (TCT ? 1:5);
                if (TC > 8)
				{ C3=C1; C1=C2; C2=C3; TC=0; }
                for (I=0; I<=CSIZE-3; I++) CXTAB[I] = CSIZE-3;
                CXTAB[CSIZE-2] = 0; CXTAB[CSIZE-1] = 0;
                if (PEN.PROX)
                  RUNTABSTOPM(5,CWIN,CRUNTAB,1,MODE,CXTAB);
                } while (!(PEN.PUSH && PEN.PROX));

               VALTRANSTAB[C0].VALUE = OLDV0; VALTRANSTAB[C0].ISNULL = FALSE;
               switch (FINDMENU(POINT,DEFMENU,DEFMENULEN)) {
                  case 0: return (FALSE); break;
                  case 1: FILLWIN(7,pWIN,PMXMID,PMYMID,PMWIDTH,PMHEIGHT,PMXMID,PMYMID);
                     return (TRUE); break;
                  default:
                  case 2:
                     X = CHECKMINMAX(X,pWIN->XORIG,PMWIDTH-1);
                     Y = CHECKMINMAX(Y,pWIN->YORIG,PMHEIGHT-1);
                     break;
                               }
               H = Y-pWIN->YORIG; W = X-pWIN->XORIG;
               FILLWIN(7,pWIN,pWIN->XORIG+W/2,pWIN->YORIG+H/2,W,H,W/2,H/2);
               do READTABLET(&POINT,&PEN); while (PEN.DOWN);
			   resovly();
               return ((pWIN->H>0) && (pWIN->W>0));
               }/*GETR*/ 


           word GETWINDOW(N,pWIN,MODE) 
			   WIN *pWIN;
             {
               POS P,P1; word Y,X;

               if (N == 1) MODE = OVBOTHQ;
               if (!GETRECT(2,pWIN,MODE)) return (FALSE);
               TABLETSTROKE(4,&P,&P1,MODE,MODE);
               switch (FINDMENU(P,DEFMENU,DEFMENULEN)) {
                 default:
				  case 0: return (FALSE); break;
                  case 1: return (TRUE); break;
                  case 2: Y = P.Y; X = P.X;
                     FILLWIN(7,pWIN,X,Y,pWIN->W,pWIN->H,
                      X-pWIN->XORIG + pWIN->XOFF,
                      Y-pWIN->YORIG + pWIN->YOFF);
                      break;
                             }
               return (TRUE);
					}


            byte READTABLET(pPOINT,pSTATUS) 
				POS *pPOINT; PENSTAT *pSTATUS;
              {/*R*/ 
			   word X,Y;

               RTABLET(pPOINT,pSTATUS);
               X = (pPOINT->X >> 1) - 010;
               Y = (pPOINT->Y >> 1) - 010;
               pPOINT->X = (X >= 0) ? X:0;
               pPOINT->Y = (Y >= 0) ? Y:0;
               return (pSTATUS->PROX);
                             }/*R*/ 


            void GRIDPT(pPT1,pPT2) 
				POS *pPT1, *pPT2;
			{
			   word X = pPT1->X, Y = pPT1->Y;
               if (!(TABGRID <= 1)) 
					{ X = ((X + (TABGRID>>1))/TABGRID)*TABGRID;
                      Y = ((Y + (TABGRID>>1))/TABGRID)*TABGRID; }
               pPT2->X = X; pPT2->Y = Y;
                      }


            void SOFTGRIDPT(pPT1,pPT2) 
				POS *pPT1, *pPT2;
			{
			   word X=pPT1->X, Y=pPT1->Y, XG, YG;

               if (!(TABGRID <= 1)) {
                      XG = (X/TABGRID)*TABGRID; YG = (Y/TABGRID)*TABGRID;
                      GRIDCNT = GRIDCNT + 1;
                      switch ((16*(X-XG))/TABGRID) {
					  case 0: case 1: case 2: case 3: case 4: case 5: case 6:
						  X = XG + 0; break;
					  case 7: case 8:
						  X = XG + (GRIDCNT & 1 ? 0:TABGRID); break;
					  case 9: case 10: case 11: case 12: case 13: case 14: case 15:
						  X = XG + TABGRID; break; }
                      switch ((16*(Y-YG))/TABGRID) {
					  case 0: case 1: case 2: case 3: case 4: case 5: case 6:
						  Y = YG + 0; break;
					  case 7: case 8:
						  Y = YG + (GRIDCNT & 1 ? 0:TABGRID); break;
					  case 9: case 10: case 11: case 12: case 13: case 14: case 15:
						  Y = YG + TABGRID; break; }
                         }
               pPT2->X = X; pPT2->Y = Y;
                      }



