
  ORG 0B34H


BOOTMS: DEFT 'SERIAL PORT INPUT '
        ORG $-1
   DEFB ASCICR
BRKMSG: DEFB LBREAK-1
   DEFM 'BREAK AT '
LBREAK EQU $-BRKMSG


        COND $>0B51H
        ERROR - ADDRESS DISPLACEMENT
        ENDC
        ORG 0B51H

DSKER: DEFB LDSKER-1
   DEFM 'DISK ERROR'
   DEFB ASCICR
LDSKER EQU $-DSKER
RATTAB DEFB 96;   50 BAUD
   DEFB 64;  75 BAUD
   DEFB 44;  110 BAUD
   DEFB 36;  134.5 BAUD
   DEFB 32;  150 BAUD
   DEFB 24;  200 BAUD
   DEFB 16;  300 BAUD
   DEFB 8;   600 BAUD
   DEFB 4;   1200 BAUD
   DEFB 2;   2400 BAUD
   DEFB 1;   4800 BAUD
   DEFB 4;   9600 BAUD (COUNTER MODE)
   DEFB 2;   19.2 KBAUD (COUNTER MODE)
   DEFB 1;   38.4 KBAUD (COUNTER MODE)

INITPM:;  INITIAL VALUES FOR STORAGE
   DEFW CONOBF;
   DEFB 0; NULLCT
   DEFB 1; LFCNT;
   DEFB '>'; PROMPT
   DEFB 7FH;   LINE DELETE CHARACTER
   DEFB 08H;   CHARACTER DELETE CHARACTER.
   DEFB 0;
   DEFW 0;
   DEFW 0; DSKVSL
   DEFW 0; BRKADR
   DEFB 10;  CRC RETRY
   DEFB 2;   WRONG SECTOR RETRY
   DEFB 2; WRONG TRACK RETRY
   DEFW -1;  CURRENT TRACK POSITIONS
   DEFW -1;
   DEFW -1;
   DEFW -1;
   DEFB -1;
   DEFW RTC0;  DISK INTERRUPT VECTOR
PARMCT EQU $-INITPM;
RGSTRS DEFM 'A B C D E F H L I A''B''C''D'''
   DEFM 'E''F''H''L''IXIYPCSP'
REGTAB:
   DEFB AF_+1&0FFH
   DEFB BC_+1&0FFH;
   DEFB BC_&0FFH;
   DEFB DE_+1&0FFH
   DEFB DE_&0FFH;
   DEFB AF_&0FFH;
   DEFB HL_+1&0FFH;
   DEFB HL_&0FFH;
   DEFB I_&0FFH;
   DEFB DE_+3&0FFH;
   DEFB DE_+5&0FFH;
   DEFB DE_+4&0FFH;   C'
   DEFB DE_+7&0FFH;   D'
   DEFB DE_+6&0FFH;   E'
   DEFB DE_+2&0FFH;   F'
   DEFB DE_+9&0FFH;
   DEFB DE_+8&0FFH;
   DEFB IX_&0FFH;
   DEFB IY_&0FFH;
   DEFB PC_&0FFH;
   DEFB SAVSTK&0FFH;
INIOUT:
   DEFB SERCON;
   DEFB 0;
   DEFB SERCON;
   DEFB 0;
   DEFB SERCON;
   DEFB 0;
   DEFB SERCON;
   DEFB 40H     ; INTERNAL RESET, ENTER MODE INSTRUCTION FORMAT
   DEFB SERCON;
   DEFB 0CEH    ; 2 STOP BITS, DISABLE PARITY, 8 DATA BITS, 16X BAUD RATE
   DEFB SERCON;
   DEFB 37H     ; RTS, ERROR RESET, RECEIVE ENABLE, DTR, TRANSMIT ENABLE
   DEFB CLK0;
   DEFB (DSKVEC.SHL.8)/256
   DEFB DSKSEL+2;
   DEFB 0CFH;
   DEFB DSKSEL+2;
   DEFB 0E0H;
   DEFB DSKCOM+2;
   DEFB 0CFH;
   DEFB DSKCOM+2;
   DEFB 0E0H;
OUTCNT EQU ($-INIOUT)/2;


; SYSTEM HOOKS   ....   MUST STAY AT 0BE8H

        COND $>0BE8H
        ERROR - ADDRESS DISPLACEMENT
        ENDC
        ORG 0BE8H


PCON:   JP TTY
        JP GET
        JP PUT
        JP PUTMSG
        JP GETCHR
        JP COMD?
PDEBUG: JP DBGRET
FLOPPY: JP FLOPY