/*	LoadICE.c - Edit 2

	LoadICE Version 4
	Copyright (C) 1990-96 Grammar Engine, Inc.
	All rights reserved
	
	NOTICE:  This software source is a licensed copy of Grammar Engine's
	property.  It is supplied to you as part of support and maintenance
	of some Grammar Engine products that you may have purchased.  Use of
	this software is strictly limited to use with such products.  Any
	other use constitutes a violation of this license to you.
*/

/*	 - LoadICE application: A ROM management utility for the PromICE
	
*/

#include <stdio.h>
#include <string.h>
#include <signal.h>

#include "piconfig.h"
#include "pistruct.h"

char *cright="Copyright (C) 1990-1998 Grammar Engine, Inc.";
#ifdef SOLARIS
char *liver="LoadICE Version 3.9d for SOLARIS w/Serial/Parallel/Ethernet-FastPort";
#else
char *liver="LoadICE Version 3.9d for UNIX w/Serial/Parallel/Ethernet-FastPort";
#endif

#ifdef ANSI
extern void piinit(void);
extern void fiinit(void);
extern void pishell(void);
extern void pi_beep(void);
extern void pcexit(void);
void licatch(int sig);
void liclick(int sig);
void main(int argc,char **argv)

#else
extern void piinit();
extern void fiinit();
extern void pishell();
extern void pi_beep();
extern void pcexit();
void licatch();
void liclick();
void main(argc,argv)
int argc;
char **argv;
#endif

	{
	char *tp;
	
	piinit();
	fiinit();

	setbuf(stdout, NULL);

	if (pxdisp&PXVH)
		printf("\n%s\n%s\n",liver,cright);

	if (argc > 1)
		{
		tp = pxcline;
		while (--argc)
			{
			strcpy(tp, *++argv);
			tp += strlen(tp);
			*tp++ = ' ';
			}
		*--tp = '\0';
		}

	signal(SIGINT,licatch);
#ifdef	FASTP
	signal(SIGALRM, liclick);
	alarm(PIC_ARM);
#endif
	pishell();

	if (pxdisp&PXVH)
		printf("\n\nExiting LoadICE - exit code %d\n",pxexitv);

	exit(pxexitv);
	}

/* `licatch` - signal catcher to terminate the application */

#ifdef ANSI
void licatch(int sig)
#else
void licatch()
#endif
	{
	if (piflags&PiER)
		piflags &= ~PiUP;
	pcexit();

	printf("\n\nTerminating LoadICE - exit code %d\n",pxexitv);

	exit(pxexitv);
	}

/* `liclick` - signal catcher to kick PromICE */

#ifdef ANSI
void liclick(int sig)
#else
void liclick()
#endif
	{
#ifdef FASTP
	if (!pibusy)
		pikick();
	signal(SIGALRM,liclick);
	alarm(PIC_ARM);
#endif
	}
